#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_EnhancementMedia : BaseTest 
	{

		private BOL.EnhancementMedia _eMedia; 
		private DataTable _dtMediaList;
		private DataRow _drMedia;
		

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();

			if (this.RefreshData)
			{
				this._dtMediaList = DAL.EnhancementMedia.GetEnhancementMediaList();
				this._drMedia = this._dtMediaList.Rows[0];

				this.RefreshData = false;
			}

			this._eMedia = new BOL.EnhancementMedia();
			this._eMedia.SetInitialBrokenRules("FrmConfigureReagent", "EnhancementMedia");
		}

		[Test]
		public void Ctor_Pass()
		{
			BOL.EnhancementMedia eMedia = new BOL.EnhancementMedia();
			Assert.IsTrue(!eMedia.Equals(null));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Fail()
		{
		}

		[Test]
		public void Ctor_DataRow_Pass()
		{	
			BOL.EnhancementMedia eMedia = new BOL.EnhancementMedia(this._drMedia);
			Assert.AreEqual(this._drMedia[TABLES.EnhancementMedia.EnhancementMediaId], eMedia.EnhancementMediaId);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(BusinessObjectException))]
		public void Ctor_DataRow_Fail()
		{	
			BOL.EnhancementMedia eMedia = new BOL.EnhancementMedia(new DataTable().NewRow());
		}

		[Test]
		public void GetEnhancementMediaList_Pass()
		{
			ArrayList alEnhancementMedia = this._eMedia.GetEnhancementMediaList();
			Assert.IsNotNull(alEnhancementMedia);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetEnhancementMediaList_Fail()
		{
		}


		[Test]
		public void EnhancementMediaID_Pass()
		{
			int origID = this._eMedia.EnhancementMediaId;
			this._eMedia.EnhancementMediaId++;

			Assert.AreEqual(++origID, this._eMedia.EnhancementMediaId);
		}

		[Test]
		public void EnhancementMediaID_Fail()
		{
			this._eMedia.EnhancementMediaId = 1;

			int brokenRulesBefore = this._eMedia.BrokenRulesCount;

			this._eMedia.EnhancementMediaId= int.MinValue;
			
			int brokenRulesAfter = this._eMedia.BrokenRulesCount;

			Assert.IsTrue(brokenRulesAfter>brokenRulesBefore);
		}

		[Test]
		public void EnhancementMediaName_Pass()
		{
			this._eMedia.EnhancementMediaName = string.Empty.PadRight(40, 'X');
			string _EnhancementMediaName = this._eMedia.EnhancementMediaName;
			Assert.AreEqual(this._eMedia.EnhancementMediaName, _EnhancementMediaName);
		}
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void EnhancementMediaName_Fail()
		{
		}

		[Test]
		public void LoadDataRowFromThis_Pass()
		{	
			DataRow drTest = this._eMedia.LoadDataRowFromThis(this._dtMediaList.NewRow());

			Assert.AreEqual(drTest[TABLES.EnhancementMedia.EnhancementMediaId],this._eMedia.EnhancementMediaId);
			Assert.AreEqual(drTest[TABLES.EnhancementMedia.EnhancementMediaName], this._eMedia.EnhancementMediaName);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(BusinessObjectException))]
		public void LoadDataRowFromThis_Fail()
		{	
			this._eMedia = new BOL.EnhancementMedia(new DataTable().NewRow());
		}

		
		[Test]
		public void VerifyMinColumnsInDataTable_Pass()
		{	
			bool tstValue = this._eMedia.VerifyMinColumnsInDataTable(BOL.EnhancementMedia.ENHANCEMENTMEDIACOLUMNS.Split(','), this._dtMediaList);

			Assert.IsTrue(tstValue);
		}

		[Test]
		public void VerifyMinColumnsInDataTable_Fail()
		{	
			bool tstValue = this._eMedia.VerifyMinColumnsInDataTable(BOL.EnhancementMedia.ENHANCEMENTMEDIACOLUMNS.Split(','), new DataTable());

			Assert.AreEqual(tstValue, false);
		}

		[Test]
		public void GetEnhancementMediaDataTable_Pass()
		{
			DataTable dt = this._eMedia.GetEnhancementMediaDataTable();

			Assert.IsTrue( dt.Rows.Count > 0 );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetEnhancementMediaDataTable_Fail()
		{
		}
	}
}
#endif


